@extends('layout')
@section('content')
    @include('partials.breadcrumb')
    <!-- contact begin-->
    <div class="address-area">
        <div class="container">
            <div class="tsk-contact-info">
                <div class="row">
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="contact-info-item">
                            <div class="icon-bar">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="info-details">
                                <h5>@lang('Address')</h5>
                                <p>{!! wordwrap($basic->address,40,"<br>\n",TRUE) !!}</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="contact-info-item">
                            <div class="icon-bar">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="info-details">
                                <h5>@lang('Email')</h5>
                                <a class="d-block" href="javascript:void(0)">
                                    {{$basic->email}}
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="contact-info-item">
                            <div class="icon-bar">
                                <i class="fas fa-mobile-alt"></i>
                            </div>
                            <div class="info-details">
                                <h5>@lang('Phone')</h5>
                                <a class="d-block" href="javascript:void(0)">{{$basic->phone}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="contact pt-120px">

        <div class="container">
            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <form class="contact-form" action="{{route('contact.submit')}}" method="post">
                        @csrf
                        <div class="row justify-content-center">
                            <div class="col-xl-8 col-lg-8">
                                <div class="section-title text-center">
                                    <h2>@lang('Contact Us For Support')</h2>
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12">
                                @if ($errors->any())
                                    @foreach ($errors->all() as $error)

                                        <div class="alert alert-danger alert-dismissible  show" role="alert">
                                             {{ __($error) }}
                                        </div>

                                    @endforeach
                                @endif
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label for="InputName">@lang('Name')<span class="requred">*</span></label>
                                    <input type="text" name="name" value="{{old('name')}}" class="form-control" id="InputName" placeholder="@lang('Enter Your Name')"  required>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label for="InputMail">@lang('E-mail')<span class="requred">*</span></label>
                                    <input type="email" name="email" value="{{old('email')}}" class="form-control" id="InputMail" placeholder="@lang('Enter Your E-mail Address')" required>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label for="InputPhone">@lang('Phone')<span class="requred">*</span></label>
                                    <input type="text" name="phone" value="{{old('phone')}}" class="form-control" id="InputPhone" placeholder="@lang('Enter Your Phone Number')"
                                           required>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label for="InputSubject">@lang('Subject')<span class="requred">*</span></label>
                                    <input type="text" name="subject" value="{{old('subject')}}" class="form-control" id="InputSubject" placeholder="@lang('Enter Your Subject')" required>
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">@lang('Message')<span class="requred">*</span></label>
                                    <textarea name="message" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="@lang('Enter Your Message')"
                                              required>{{old('message')}}</textarea>
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12">
                                <button type="submit">@lang('Send Now')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="google-map" id="map"  data-latitude="{{$basic->latitude}}" data-longitude="{{$basic->longitude}}"></div>

    </div>
    <!-- contact end -->



@stop

@section('script')
    <!--    map js -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBqFuLx8S7A8eianoUhkYMeXpGPvsXp1NM&callback" async defer></script>
@stop